<?php
require_once '../config/conexion.php';

/* Cabeceras + TZ */
header('Content-Type: application/json; charset=utf-8');
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");
header("Expires: 0");

date_default_timezone_set('America/Lima');
if (isset($conexion) && $conexion instanceof mysqli) {
  @mysqli_set_charset($conexion, 'utf8');
  @mysqli_query($conexion, "SET time_zone = '-05:00'");
}

$sql = "SELECT id, nombre FROM categorias ORDER BY nombre ASC";
$resultado = $conexion->query($sql);

$categorias = [];
while ($row = $resultado->fetch_assoc()) {
  $categorias[] = ['id' => (int)$row['id'], 'nombre' => $row['nombre']];
}

echo json_encode($categorias, JSON_UNESCAPED_UNICODE);
