<?php
require_once "../config/conexion.php";

/* === Cabeceras anti-caché + JSON UTF-8 === */
header("Content-Type: application/json; charset=utf-8");
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");
header("Expires: 0");

/* === Zona horaria y charset para la sesión PHP/MySQL === */
date_default_timezone_set('America/Lima');
if (isset($conexion) && $conexion instanceof mysqli) {
    @mysqli_set_charset($conexion, 'utf8');
    @mysqli_query($conexion, "SET time_zone = '-05:00'");
}

/* === Helpers JSON === */
function responderError($mensaje) {
    echo json_encode(['success' => false, 'message' => $mensaje], JSON_UNESCAPED_UNICODE);
    exit;
}
function responderOk($payload) {
    echo json_encode($payload, JSON_UNESCAPED_UNICODE);
    exit;
}

$accion = $_GET['accion'] ?? '';

/* ==========================
   OBTENER TODOS LOS PRODUCTOS
   ========================== */
if ($accion === 'obtener') {
    // 👉 Usamos COALESCE(fecha_ingreso, DATE(created_at)) para que en la MISMA COLUMNA
    //     venga la fecha de ingreso o, si no existe, la fecha de creación.
    $sql = "SELECT 
                p.id, p.codigo, p.nombre, p.imagen,
                p.stock, p.stock_minimo,
                COALESCE(p.fecha_ingreso, DATE(p.created_at)) AS fecha_ingreso,
                p.tipo_id, t.nombre AS tipo,
                p.categoria_id, c.nombre AS categoria,
                p.medida_id, m.nombre AS medida
            FROM productos p
            LEFT JOIN tipos t ON p.tipo_id = t.id
            LEFT JOIN categorias c ON p.categoria_id = c.id
            LEFT JOIN medidas m ON p.medida_id = m.id
            ORDER BY p.id DESC";

    $resultado = $conexion->query($sql);
    if (!$resultado) responderError("Error al obtener productos.");

    $productos = [];
    while ($fila = $resultado->fetch_assoc()) {
        // Obtener códigos QR por producto SIN get_result()
        $qrs = [];
        if ($stmtQR = $conexion->prepare("SELECT codigo_qr FROM codigos_qr WHERE producto_id = ?")) {
            $stmtQR->bind_param("i", $fila['id']);
            $stmtQR->execute();
            $stmtQR->store_result();
            $stmtQR->bind_result($codigoQR);
            while ($stmtQR->fetch()) { $qrs[] = $codigoQR; }
            $stmtQR->free_result();
            $stmtQR->close();
        }
        $fila['codigos_qr'] = $qrs;

        // Aseguramos que la fecha vaya en ISO YYYY-MM-DD (o null)
        $rawFecha = $fila['fecha_ingreso'] ?? null;
        if (empty($rawFecha) || $rawFecha === '0000-00-00') {
            $fila['fecha_ingreso'] = null;
        } else {
            $fila['fecha_ingreso'] = $rawFecha; // YYYY-MM-DD
        }

        $productos[] = $fila;
    }

    responderOk($productos);
}

/* ==========================
   CARGAR OPCIONES PARA SELECTS
   ========================== */
if ($accion === 'selects') {
    $tipos = [];
    $categorias = [];
    $medidas = [];

    if ($res = $conexion->query("SELECT id, nombre FROM tipos ORDER BY nombre ASC")) {
        while ($row = $res->fetch_assoc()) $tipos[] = $row;
    }
    if ($res = $conexion->query("SELECT id, nombre FROM categorias ORDER BY nombre ASC")) {
        while ($row = $res->fetch_assoc()) $categorias[] = $row;
    }
    if ($res = $conexion->query("SELECT id, nombre FROM medidas ORDER BY nombre ASC")) {
        while ($row = $res->fetch_assoc()) $medidas[] = $row;
    }

    responderOk([
        'tipos' => $tipos,
        'categorias' => $categorias,
        'medidas' => $medidas
    ]);
}

/* ==========================
   LISTAR CÓDIGOS QR POR PRODUCTO
   ========================== */
if (
    $_SERVER['REQUEST_METHOD'] === 'POST' &&
    ($accion === 'listar_qr' || (isset($_POST['accion']) && $_POST['accion'] === 'listar_qr')) &&
    isset($_POST['producto_id'])
) {
    $producto_id = intval($_POST['producto_id']);

    $qrs = [];
    if ($stmt = $conexion->prepare("SELECT codigo_qr FROM codigos_qr WHERE producto_id = ?")) {
        $stmt->bind_param("i", $producto_id);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($codigoQR);
        while ($stmt->fetch()) { $qrs[] = $codigoQR; }
        $stmt->free_result();
        $stmt->close();
    }

    responderOk(['success' => true, 'codigos_qr' => $qrs]);
}

/* ==========================
   ACCIÓN NO VÁLIDA
   ========================== */
responderError("Acción no válida.");
