<?php
require_once '../config/conexion.php';

header('Content-Type: application/json; charset=UTF-8');
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");
header("Expires: 0");

ini_set('display_errors', 1);
error_reporting(E_ALL);

date_default_timezone_set('America/Lima');
if (isset($conexion) && $conexion instanceof mysqli) {
  @mysqli_set_charset($conexion, 'utf8');
  @mysqli_query($conexion, "SET time_zone = '-05:00'");
}

/* Helper sin mysqlnd */
if (!function_exists('stmt_fetch_all_assoc')) {
  function stmt_fetch_all_assoc(mysqli_stmt $stmt): array {
    $stmt->store_result();
    $meta = $stmt->result_metadata();
    if (!$meta) return [];
    $row = []; $bind = [];
    while ($field = $meta->fetch_field()) { $bind[] = &$row[$field->name]; }
    call_user_func_array([$stmt, 'bind_result'], $bind);
    $out = [];
    while ($stmt->fetch()) { $out[] = array_map(fn($v)=>$v, $row); }
    $stmt->free_result();
    return $out;
  }
}

$accion = $_GET['accion'] ?? '';

try {
  if ($accion === 'registro') {
    // Productos defectuosos registrados directamente
    $stmt = $conexion->prepare("
      SELECT pd.id, p.nombre AS nombre, pd.codigo_qr, pd.cantidad, pd.fecha_registro, 
             pd.descripcion, pd.observacion 
      FROM productos_defectuosos pd 
      INNER JOIN productos p ON pd.producto_id = p.id
      ORDER BY pd.id DESC
    ");
    $stmt->execute();
    $rows = stmt_fetch_all_assoc($stmt);

    $datos = [];
    foreach ($rows as $row) {
      $datos[] = [
        'id' => (int)$row['id'],
        'nombre' => $row['nombre'],
        'codigo_qr' => $row['codigo_qr'] ?? '',
        'cantidad' => isset($row['cantidad']) ? (int)$row['cantidad'] : null,
        'fecha_registro' => $row['fecha_registro'],
        'descripcion' => $row['descripcion'] ?? '',
        'observacion' => $row['observacion'] ?? ''
      ];
    }
    echo json_encode($datos, JSON_UNESCAPED_UNICODE);
    exit;

  } elseif ($accion === 'devueltos') {
    // Devueltos como defectuosos desde movimientos
    $stmt = $conexion->prepare("
      SELECT m.id, p.nombre AS nombre, m.codigo_qr, m.motivo, m.responsable, m.fecha_retorno 
      FROM movimientos m 
      INNER JOIN productos p ON m.producto_id = p.id
      WHERE m.estado_retorno = 'devuelto_defectuoso'
      ORDER BY m.id DESC
    ");
    $stmt->execute();
    $rows = stmt_fetch_all_assoc($stmt);

    $datos = [];
    foreach ($rows as $row) {
      $datos[] = [
        'id' => (int)$row['id'],
        'nombre' => $row['nombre'],
        'codigo_qr' => $row['codigo_qr'] ?? '',
        'motivo' => $row['motivo'] ?? '',
        'responsable' => $row['responsable'] ?? '',
        'fecha_retorno' => $row['fecha_retorno'] ?? ''
      ];
    }
    echo json_encode($datos, JSON_UNESCAPED_UNICODE);
    exit;

  } else {
    http_response_code(400);
    echo json_encode(['error' => 'Acción no válida'], JSON_UNESCAPED_UNICODE);
    exit;
  }

} catch (Exception $e) {
  http_response_code(500);
  echo json_encode(['error' => 'Error en la consulta: ' . $e->getMessage()], JSON_UNESCAPED_UNICODE);
  exit;
}
