<?php
require_once "../config/conexion.php";

/* Cabeceras + TZ */
header('Content-Type: application/json; charset=utf-8');
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");
header("Expires: 0");

date_default_timezone_set('America/Lima');
if (isset($conexion) && $conexion instanceof mysqli) {
  @mysqli_set_charset($conexion, 'utf8');
  @mysqli_query($conexion, "SET time_zone = '-05:00'");
}

/* Helper sin mysqlnd */
if (!function_exists('stmt_fetch_all_assoc')) {
  function stmt_fetch_all_assoc(mysqli_stmt $stmt): array {
    $stmt->store_result();
    $meta = $stmt->result_metadata();
    if (!$meta) return [];
    $row = []; $bind = [];
    while ($field = $meta->fetch_field()) { $bind[] = &$row[$field->name]; }
    call_user_func_array([$stmt, 'bind_result'], $bind);
    $out = [];
    while ($stmt->fetch()) { $out[] = array_map(fn($v)=>$v, $row); }
    $stmt->free_result();
    return $out;
  }
}

$accion = $_GET['accion'] ?? '';

switch ($accion) {
  case 'stock':
    $consulta = $conexion->query("
      SELECT p.nombre AS producto, t.nombre AS tipo, c.nombre AS categoria, m.nombre AS medida, p.stock
      FROM productos p
      INNER JOIN tipos t ON p.tipo_id = t.id
      INNER JOIN categorias c ON p.categoria_id = c.id
      INNER JOIN medidas m ON p.medida_id = m.id
    ");
    $data = [];
    while ($row = $consulta->fetch_assoc()) { $data[] = $row; }
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    break;

  case 'nodevueltos':
    $consulta = $conexion->query("
      SELECT p.nombre AS producto, 
             IFNULL(t.nombre, m.responsable) AS responsable, 
             m.fecha AS fecha, 
             m.fecha_retorno, 
             m.estado_retorno AS estado
      FROM movimientos m
      INNER JOIN productos p ON m.producto_id = p.id
      LEFT JOIN trabajadores t ON m.trabajador_id = t.id
      WHERE m.estado_retorno = 'pendiente'
    ");
    $data = [];
    while ($row = $consulta->fetch_assoc()) { $data[] = $row; }
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    break;

  case 'por_trabajador':
    $id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
    $consulta = $conexion->prepare("
      SELECT p.nombre AS producto, m.fecha AS fecha, m.fecha_retorno, m.estado_retorno AS estado
      FROM movimientos m
      INNER JOIN productos p ON m.producto_id = p.id
      WHERE m.trabajador_id = ?
    ");
    $consulta->bind_param("i", $id);
    $consulta->execute();
    $data = stmt_fetch_all_assoc($consulta);
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    break;

  default:
    echo json_encode([], JSON_UNESCAPED_UNICODE);
    break;
}
