document.addEventListener("DOMContentLoaded", function () {
  cargarStock();
  cargarNoDevueltos();

  const select = document.getElementById("selectTrabajador");
  select.addEventListener("change", function () {
    const id = this.value;
    if (id) {
      fetch(`../../ajax/reportes_ajax.php?accion=por_trabajador&id=${id}`)
        .then(res => res.json())
        .then(data => {
          $('#tablaPorTrabajador').DataTable({
            destroy: true,
            data: data,
            responsive: true,
            scrollX: true,
            dom: 'Bfrtip',
            buttons: ['excel', 'print'],
            columns: [
              { data: 'producto' },
              { data: 'fecha' },
              { data: 'fecha_retorno' },
              { data: 'estado' }
            ],
            language: {
              url: 'https://cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json'
            }
          });
        });
    } else {
      $('#tablaPorTrabajador').DataTable().clear().draw(); // limpiar si no se selecciona
    }
  });

  function cargarStock() {
    fetch("../../ajax/reportes_ajax.php?accion=stock")
      .then(res => res.json())
      .then(data => {
        $('#tablaStock').DataTable({
          destroy: true,
          data: data,
          responsive: true,
          scrollX: true,
          dom: 'Bfrtip',
          buttons: ['excel', 'print'],
          columns: [
            { data: null, render: (data, type, row, meta) => meta.row + 1 },
            { data: 'producto' },
            { data: 'tipo' },
            { data: 'categoria' },
            { data: 'medida' },
            { data: 'stock' }
          ],
          language: {
            url: 'https://cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json'
          }
        });
      });
  }

  function cargarNoDevueltos() {
    fetch("../../ajax/reportes_ajax.php?accion=nodevueltos")
      .then(res => res.json())
      .then(data => {
        $('#tablaNoDevueltos').DataTable({
          destroy: true,
          data: data,
          responsive: true,
          scrollX: true,
          dom: 'Bfrtip',
          buttons: ['excel', 'print'],
          columns: [
            { data: 'producto' },
            { data: 'responsable' },
            { data: 'fecha' },
            { data: 'fecha_retorno' },
            { data: 'estado' }
          ],
          language: {
            url: 'https://cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json'
          }
        });
      });
  }
});
