document.addEventListener("DOMContentLoaded", () => {
  cargarTrabajadores();

  const form = document.getElementById("formTrabajador");
  form.addEventListener("submit", function (e) {
    e.preventDefault();

    const datos = new FormData(form);

    fetch("../../controllers/guardar_trabajador.php", {
      method: "POST",
      body: datos
    })
      .then(res => res.json())
      .then(resp => {
        if (resp.success) {
          $('#modalTrabajador').modal('hide');
          form.reset();
          cargarTrabajadores();
          Swal.fire("Registrado", resp.message || "Trabajador guardado correctamente", "success");
        } else {
          Swal.fire("Error", resp.message || "No se pudo guardar el trabajador", "error");
        }
      })
      .catch(error => {
        console.error("Error en la solicitud:", error);
        Swal.fire("Error", "Error de conexión con el servidor", "error");
      });
  });
});

function cargarTrabajadores() {
  fetch("../../ajax/trabajadores_ajax.php?accion=obtener")
    .then(res => res.json())
    .then(data => {
      const tbody = document.querySelector("#tablaTrabajadores tbody");
      tbody.innerHTML = "";

      if (Array.isArray(data)) {
        data.forEach(t => {
          tbody.innerHTML += `
            <tr>
              <td>${t.nombre}</td>
              <td>${t.dni}</td>
              <td>${t.telefono}</td>
              <td>${t.correo}</td>
              <td>${t.cargo}</td>
              <td>${t.fecha_registro}</td>
              <td>
                <form method="POST" action="../../controllers/eliminar_trabajador.php" onsubmit="return confirm('¿Eliminar este trabajador?')">
                  <input type="hidden" name="id" value="${t.id}">
                  <button class="btn btn-sm btn-danger">Eliminar</button>
                </form>
              </td>
            </tr>`;
        });
      } else {
        Swal.fire("Error", "Respuesta inesperada del servidor", "error");
      }
    })
    .catch(error => {
      console.error("Error al cargar trabajadores:", error);
      Swal.fire("Error", "No se pudo cargar la lista de trabajadores", "error");
    });
}
