<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include '../config/conexion.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nombre = trim($_POST['nombre']);
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;

    if (empty($nombre)) {
        header("Location: ../views/modulos/categorias.php?error=campos");
        exit();
    }

    if (isset($_POST['registrar'])) {
        $verificar = $conexion->prepare("SELECT * FROM categorias WHERE nombre = ?");
        $verificar->bind_param("s", $nombre);
        $verificar->execute();
        $resultado = $verificar->get_result();

        if ($resultado->num_rows > 0) {
            header("Location: ../views/modulos/categorias.php?error=duplicado");
            exit();
        }

        $stmt = $conexion->prepare("INSERT INTO categorias (nombre) VALUES (?)");
        $stmt->bind_param("s", $nombre);
        $stmt->execute();

        if ($stmt->affected_rows > 0) {
            header("Location: ../views/modulos/categorias.php?mensaje=registrado");
        } else {
            header("Location: ../views/modulos/categorias.php?error=fallo");
        }
        $stmt->close();
    }

    if (isset($_POST['actualizar']) && $id > 0) {
        $verificar = $conexion->prepare("SELECT * FROM categorias WHERE nombre = ? AND id != ?");
        $verificar->bind_param("si", $nombre, $id);
        $verificar->execute();
        $resultado = $verificar->get_result();

        if ($resultado->num_rows > 0) {
            header("Location: ../views/modulos/categorias.php?error=duplicado");
            exit();
        }

        $stmt = $conexion->prepare("UPDATE categorias SET nombre = ? WHERE id = ?");
        $stmt->bind_param("si", $nombre, $id);
        $stmt->execute();

        if ($stmt->affected_rows > 0) {
            header("Location: ../views/modulos/categorias.php?mensaje=actualizado");
        } else {
            header("Location: ../views/modulos/categorias.php?error=sin_cambios");
        }
        $stmt->close();
    }

    $conexion->close();
}
