<?php
include '../config/conexion.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nombre = trim($_POST['nombre']);

    if (empty($nombre)) {
        header("Location: ../views/modulos/medidas.php?error=campos");
        exit();
    }

    // Verificar duplicado
    $verificar = $conexion->prepare("SELECT * FROM medidas WHERE nombre = ?");
    $verificar->bind_param("s", $nombre);
    $verificar->execute();
    $resultado = $verificar->get_result();

    if ($resultado->num_rows > 0) {
        header("Location: ../views/modulos/medidas.php?error=duplicado");
        exit();
    }

    $stmt = $conexion->prepare("INSERT INTO medidas (nombre) VALUES (?)");
    $stmt->bind_param("s", $nombre);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        header("Location: ../views/modulos/medidas.php?mensaje=registrado");
    } else {
        header("Location: ../views/modulos/medidas.php?error=fallo");
    }

    $stmt->close();
    $conexion->close();
}
