<?php
require_once '../config/conexion.php';
header('Content-Type: application/json; charset=UTF-8');

try {
    // Sanitizar entradas
    $producto_id = isset($_POST['producto_id']) ? intval($_POST['producto_id']) : null;
    $cantidad = isset($_POST['cantidad']) ? intval($_POST['cantidad']) : 1;
    $descripcion = trim($_POST['descripcion'] ?? '');
    $observacion = trim($_POST['observacion'] ?? '');
    $codigo_qr = trim($_POST['codigo_qr'] ?? '');

    // Validación básica
    if (!$producto_id || $cantidad < 1) {
        echo json_encode(['success' => false, 'message' => 'Producto o cantidad inválida']);
        exit;
    }

    // Preparar consulta
    $stmt = $conexion->prepare("INSERT INTO productos_defectuosos 
        (producto_id, cantidad, descripcion, observacion, codigo_qr) 
        VALUES (?, ?, ?, ?, ?)");

    $stmt->bind_param("iisss", $producto_id, $cantidad, $descripcion, $observacion, $codigo_qr);

    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Producto defectuoso registrado correctamente']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al registrar el producto']);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error del servidor: ' . $e->getMessage()]);
}
