<?php
include '../config/conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $codigo = trim($_POST['codigo']);
    $trabajador = trim($_POST['trabajador']);
    $motivo = trim($_POST['motivo']);
    $cantidad = intval($_POST['cantidad']);
    $tipo_movimiento = 'salida_sin_retorno';
    $fecha = date('Y-m-d H:i:s');
    $estado = 'sin retorno';

    try {
        // Buscar el producto por su código
        $stmt = $conexion->prepare("SELECT id, stock FROM productos WHERE codigo = ?");
        $stmt->execute([$codigo]);
        $producto = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$producto) {
            header("Location: ../views/modulos/salida_sin_retorno.php?mensaje=error");
            exit();
        }

        // Verificar si hay stock suficiente
        if ($producto['stock'] < $cantidad) {
            header("Location: ../views/modulos/salida_sin_retorno.php?mensaje=error");
            exit();
        }

        // Insertar el movimiento
        $stmt = $conexion->prepare("INSERT INTO movimientos (producto_id, trabajador, tipo_movimiento, cantidad, motivo, fecha_salida, estado) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([
            $producto['id'],
            $trabajador,
            $tipo_movimiento,
            $cantidad,
            $motivo,
            $fecha,
            $estado
        ]);

        // Actualizar el stock del producto
        $nuevo_stock = $producto['stock'] - $cantidad;
        $stmt = $conexion->prepare("UPDATE productos SET stock = ? WHERE id = ?");
        $stmt->execute([$nuevo_stock, $producto['id']]);

        header("Location: ../views/modulos/salida_sin_retorno.php?mensaje=registrado");
        exit();
    } catch (Exception $e) {
        header("Location: ../views/modulos/salida_sin_retorno.php?mensaje=error");
        exit();
    }
} else {
    header("Location: ../views/modulos/salida_sin_retorno.php");
    exit();
}
