<?php
require_once '../config/conexion.php';

header('Content-Type: application/json');

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validación básica
    $nombre = trim($_POST['nombre'] ?? '');
    $dni = trim($_POST['dni'] ?? '');
    $telefono = trim($_POST['telefono'] ?? '');
    $correo = trim($_POST['correo'] ?? '');
    $cargo = trim($_POST['cargo'] ?? '');

    if (empty($nombre) || empty($dni) || empty($telefono) || empty($correo) || empty($cargo)) {
        $response['message'] = "Todos los campos son obligatorios.";
        echo json_encode($response);
        exit;
    }

    // Insertar en la base de datos
    $sql = "INSERT INTO trabajadores (nombre, dni, telefono, correo, cargo, fecha_registro)
            VALUES (?, ?, ?, ?, ?, NOW())";
    $stmt = $conexion->prepare($sql);

    if ($stmt) {
        $stmt->bind_param("sssss", $nombre, $dni, $telefono, $correo, $cargo);
        if ($stmt->execute()) {
            $response['success'] = true;
        } else {
            $response['message'] = "Error al ejecutar SQL: " . $stmt->error;
        }
    } else {
        $response['message'] = "Error en preparación de SQL: " . $conexion->error;
    }
} else {
    $response['message'] = "Método no permitido";
}

echo json_encode($response);
