<?php
include '../config/conexion.php';

if (isset($_POST['registrar_salida'])) {
    $codigo = $_POST['codigo'];
    $trabajador = $_POST['trabajador'];
    $motivo = $_POST['motivo'];
    $cantidad = intval($_POST['cantidad']);
    $fecha_retorno = $_POST['fecha_retorno'];

    // Verificar si existe el producto
    $stmt = $conexion->prepare("SELECT id, stock FROM productos WHERE codigo = ?");
    $stmt->bind_param("s", $codigo);
    $stmt->execute();
    $resultado = $stmt->get_result();

    if ($resultado->num_rows === 0) {
        header("Location: ../views/modulos/movimientos.php?error=producto_no_encontrado");
        exit();
    }

    $producto = $resultado->fetch_assoc();
    $producto_id = $producto['id'];
    $stock_actual = $producto['stock'];

    // Verificar stock suficiente
    if ($cantidad > $stock_actual) {
        header("Location: ../views/modulos/movimientos.php?error=stock_insuficiente");
        exit();
    }

    // Descontar stock del producto
    $nuevo_stock = $stock_actual - $cantidad;
    $stmt_update = $conexion->prepare("UPDATE productos SET stock = ? WHERE id = ?");
    $stmt_update->bind_param("ii", $nuevo_stock, $producto_id);
    $stmt_update->execute();

    // Insertar movimiento
    $stmt_mov = $conexion->prepare("INSERT INTO movimientos (producto_id, tipo_movimiento, cantidad, motivo, fecha, fecha_retorno, estado) VALUES (?, 'salida', ?, ?, NOW(), ?, 'pendiente')");
    $stmt_mov->bind_param("iiss", $producto_id, $cantidad, $motivo, $fecha_retorno);
    $stmt_mov->execute();

    header("Location: ../views/modulos/movimientos.php?mensaje=registrado");
    exit();
}
?>
