<?php
include '../config/conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario = $_POST['usuario'] ?? '';
    $nombre = $_POST['nombre'] ?? '';
    $clave = $_POST['clave'] ?? '';

    if (empty($usuario) || empty($nombre) || empty($clave)) {
        echo "Todos los campos son obligatorios.";
        exit;
    }

    // Verificar si el usuario ya existe
    $stmt = $conexion->prepare("SELECT id FROM usuarios WHERE usuario = ?");
    $stmt->bind_param("s", $usuario);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        echo "El nombre de usuario ya está registrado.";
        exit;
    }

    // Hashear la contraseña
    $clave_hash = password_hash($clave, PASSWORD_DEFAULT);

    // Insertar usuario
    $stmt = $conexion->prepare("INSERT INTO usuarios (usuario, nombre, clave) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $usuario, $nombre, $clave_hash);

    if ($stmt->execute()) {
        echo "✅ Usuario registrado correctamente.";
    } else {
        echo "❌ Error al registrar el usuario.";
    }

    $stmt->close();
    $conexion->close();
}
?>
