<?php
session_start();
include '../config/conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario = $_POST['usuario'] ?? '';
    $clave = $_POST['password'] ?? ''; // Nombre del input en login.php

    // Buscar usuario
    $stmt = $conexion->prepare("SELECT * FROM usuarios WHERE usuario = ?");
    $stmt->bind_param("s", $usuario);
    $stmt->execute();
    $resultado = $stmt->get_result();

    if ($resultado->num_rows === 1) {
        $fila = $resultado->fetch_assoc();

        // Verificar contraseña encriptada
        if (password_verify($clave, $fila['clave'])) {
            $_SESSION['usuario'] = $fila['usuario'];
            $_SESSION['nombre'] = $fila['nombre'] ?? '';
            header("Location: ../views/modulos/dashboard.php");
            exit();
        }
    }

    // Si falla
    header("Location: ../login.php?error=1");
    exit();
}
?>
