<?php
session_start();

// Si ya est logueado, redirigir
if (isset($_SESSION['usuario_id'])) {
    header("Location: views/modulos/dashboard.php");
    exit();
}

require_once "config/conexion.php";
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Login - ALMACENCRM</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- AdminLTE + estilos -->
  <link rel="stylesheet" href="assets/adminlte/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="assets/adminlte/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="assets/adminlte/css/custom-style.css">
  <link rel="icon" href="assets/adminlte/img/enpex_logo.png">
  
  <style>
    body {
      background-color: #f4f6f9;
    }
    .login-box {
      margin-top: 100px;
    }
    .login-logo img {
      max-height: 70px;
      margin-bottom: 15px;
    }
    .login-box-msg {
      font-size: 1.1rem;
      font-weight: bold;
    }
  </style>
</head>

<body class="hold-transition login-page">
<div class="login-box">
  <div class="text-center login-logo">
    <img src="assets/adminlte/img/enpex_logo.png" alt="Logo ENPEX">
    <div class="mt-2"> <span style="font-weight:bold; font-size:24px;">ALMACEN</span><span style="font-size:24px;">CRM</span></div>
  </div>

  <div class="card">
    <div class="card-body login-card-body">
      <p class="login-box-msg">Ingresa tus datos para continuar</p>

      <?php if (isset($_GET['error'])): ?>
        <div class="alert alert-danger">Usuario o contrase09a incorrectos.</div>
      <?php endif; ?>

      <form action="controllers/validar.php" method="POST">
        <div class="input-group mb-3">
          <input type="text" name="usuario" class="form-control" placeholder="Usuario" required>
          <div class="input-group-append">
            <div class="input-group-text"><span class="fas fa-user"></span></div>
          </div>
        </div>

        <div class="input-group mb-3">
          <input type="password" name="password" class="form-control" placeholder="Contrasena" required>
          <div class="input-group-append">
            <div class="input-group-text"><span class="fas fa-lock"></span></div>
          </div>
        </div>

        <div class="row">
          <div class="col-12">
            <button type="submit" class="btn btn-primary btn-block">Ingresar</button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- JS AdminLTE -->
<script src="assets/adminlte/plugins/jquery/jquery.min.js"></script>
<script src="assets/adminlte/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/adminlte/dist/js/adminlte.min.js"></script>
</body>
</html>
