<?php
include '../config/conexion.php';

if (isset($_POST['registrar_movimiento'])) {
    $codigo = $_POST['codigo'];
    $tipo = $_POST['tipo']; // 'entrada' o 'salida'
    $cantidad = intval($_POST['cantidad']);
    $motivo = $_POST['motivo'];

    // Validación básica
    if (empty($codigo) || empty($tipo) || $cantidad <= 0) {
        echo "Error: Datos incompletos.";
        exit;
    }

    // Obtener el producto
    $stmt = $conexion->prepare("SELECT id, stock FROM productos WHERE codigo = ?");
    $stmt->bind_param("s", $codigo);
    $stmt->execute();
    $resultado = $stmt->get_result();

    if ($resultado->num_rows === 0) {
        echo "Error: Producto no encontrado.";
        exit;
    }

    $producto = $resultado->fetch_assoc();
    $stock_actual = $producto['stock'];

    if ($tipo === 'salida' && $stock_actual < $cantidad) {
        echo "Error: Stock insuficiente.";
        exit;
    }

    // Calcular nuevo stock
    $nuevo_stock = ($tipo === 'entrada') ? $stock_actual + $cantidad : $stock_actual - $cantidad;

    // Actualizar stock
    $stmt = $conexion->prepare("UPDATE productos SET stock = ? WHERE id = ?");
    $stmt->bind_param("ii", $nuevo_stock, $producto['id']);
    $stmt->execute();

    // Opcional: registrar el movimiento en una tabla "movimientos"
    /*
    $stmt = $conexion->prepare("INSERT INTO movimientos (codigo_producto, tipo, cantidad, motivo) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("ssis", $codigo, $tipo, $cantidad, $motivo);
    $stmt->execute();
    */

    header("Location: ../views/modulos/entradas_salidas.php?ok");
    exit;
}
?>
