<?php
include '../config/conexion.php'; // Ajusta ruta si cambia al subir a hosting

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require '../PHPMailer/src/Exception.php';
require '../PHPMailer/src/PHPMailer.php';
require '../PHPMailer/src/SMTP.php';

// Configuración de UltraMSG
$instance_id = 'instance135272';
$token = '8n0k4s0smxae0ssv';
$ultramsg_url = "https://api.ultramsg.com/instance135272/messages/chat";

// Fecha actual
$hoy = date("Y-m-d");

// Obtener productos no devueltos
$sql = "SELECT m.id, m.fecha_retorno, m.trabajador, t.telefono, p.nombre AS producto 
        FROM movimientos m
        INNER JOIN productos p ON m.producto_id = p.id
        INNER JOIN trabajadores t ON m.trabajador = t.nombre
        WHERE m.estado = 'pendiente' AND m.fecha_retorno < ?";
$stmt = $conexion->prepare($sql);
$stmt->bind_param("s", $hoy);
$stmt->execute();
$resultado = $stmt->get_result();

while ($fila = $resultado->fetch_assoc()) {
    $producto = $fila['producto'];
    $trabajador = $fila['trabajador'];
    $telefono = $fila['telefono'];
    $fecha_retorno = $fila['fecha_retorno'];

    // Enviar correo
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'mail.tudominio.com'; // Cambiar por el host SMTP de tu dominio
        $mail->SMTPAuth = true;
        $mail->Username = 'alertas@tudominio.com'; // Cambiar por tu correo
        $mail->Password = 'tu_contraseña';         // Cambiar por tu contraseña
        $mail->SMTPSecure = 'tls';
        $mail->Port = 587;

        $mail->setFrom('alertas@tudominio.com', 'ALMACENCRM');
        $mail->addAddress('destino@correo.com'); // o correo de administrador
        $mail->Subject = "⚠️ Producto no devuelto";
        $mail->Body = "El trabajador $trabajador no ha devuelto el producto '$producto' cuya fecha límite era $fecha_retorno.";

        $mail->send();
    } catch (Exception $e) {
        error_log("Error al enviar correo: {$mail->ErrorInfo}");
    }

    // Enviar mensaje por WhatsApp
    $mensaje = "⚠️ Alerta:\nEl trabajador *$trabajador* no ha devuelto el producto *$producto* (venció: $fecha_retorno).";
    $numero = "51" . preg_replace('/\D/', '', $telefono); // Limpia y añade +51 Perú

    $data = [
        'token' => $token,
        'to' => $numero,
        'body' => $mensaje
    ];

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $ultramsg_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data),
        CURLOPT_HTTPHEADER => ["Content-Type: application/x-www-form-urlencoded"]
    ]);
    curl_exec($ch);
    curl_close($ch);
}
?>
