<?php
// ⬇️ Anti-caché: debe ir ANTES de cualquier salida
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");
header("Expires: 0");

require_once '../../config/conexion.php';
require_once __DIR__ . '/../templates/header.php';
require_once __DIR__ . '/../templates/navbar.php';
require_once __DIR__ . '/../templates/sidebar.php';

// Consultas resumen
$total_productos   = $conexion->query("SELECT COUNT(*) FROM productos")->fetch_row()[0];
$total_movimientos = $conexion->query("SELECT COUNT(*) FROM movimientos")->fetch_row()[0];
$total_usuarios    = $conexion->query("SELECT COUNT(*) FROM usuarios")->fetch_row()[0];
$total_tipos       = $conexion->query("SELECT COUNT(*) FROM tipos")->fetch_row()[0];
?>

<div class="content-wrapper" style="background-color: #ffffff;">
  <div class="content-header">
    <div class="container-fluid text-center">
      <h1 class="m-0 text-dark font-weight-bold">Panel Principal</h1>
    </div>
  </div>

  <div class="content">
    <div class="container-fluid">
      <!-- Tarjetas resumen -->
      <div class="row">
        <div class="col-md-3">
          <div class="small-box bg-primary">
            <div class="inner"><h3><?= $total_productos ?></h3><p>Productos</p></div>
            <div class="icon"><i class="fas fa-box"></i></div>
            <a href="<?= BASE_URL ?>views/modulos/productos.php" class="small-box-footer">Ir a Productos <i class="fas fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <div class="col-md-3">
          <div class="small-box bg-success">
            <div class="inner"><h3><?= $total_movimientos ?></h3><p>Movimientos</p></div>
            <div class="icon"><i class="fas fa-exchange-alt"></i></div>
            <a href="<?= BASE_URL ?>views/modulos/movimientos.php" class="small-box-footer">Ir a Movimientos <i class="fas fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <div class="col-md-3">
          <div class="small-box bg-warning">
            <div class="inner"><h3><?= $total_usuarios ?></h3><p>Usuarios</p></div>
            <div class="icon"><i class="fas fa-users-cog"></i></div>
            <a href="<?= BASE_URL ?>views/modulos/usuarios.php" class="small-box-footer">Ir a Usuarios <i class="fas fa-arrow-circle-right"></i></a>
          </div>
        </div>
        <div class="col-md-3">
          <div class="small-box bg-info">
            <div class="inner"><h3><?= $total_tipos ?></h3><p>Tipos de Producto</p></div>
            <div class="icon"><i class="fas fa-tags"></i></div>
            <a href="<?= BASE_URL ?>views/modulos/tipos.php" class="small-box-footer">Ir a Tipos <i class="fas fa-arrow-circle-right"></i></a>
          </div>
        </div>
      </div>

      <!-- Gráfico -->
      <div class="card border border-primary">
        <div class="card-header bg-white text-dark font-weight-bold">Resumen General</div>
        <div class="card-body">
          <canvas id="resumenChart" height="120"></canvas>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Scripts de gráfico -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
  const ctx = document.getElementById('resumenChart').getContext('2d');
  new Chart(ctx, {
    type: 'bar',
    data: {
      labels: ['Productos', 'Movimientos', 'Usuarios', 'Tipos'],
      datasets: [{
        label: 'Cantidad',
        data: [<?= $total_productos ?>, <?= $total_movimientos ?>, <?= $total_usuarios ?>, <?= $total_tipos ?>],
        backgroundColor: ['#007bff', '#28a745', '#ffc107', '#17a2b8']
      }]
    },
    options: {
      responsive: true,
      plugins: { legend: { labels: { color: '#000' } } },
      scales: { x: { ticks: { color: '#000' } }, y: { ticks: { color: '#000' } } }
    }
  });

  // ⬇️ Fix bfcache + opcional refresco suave
  window.addEventListener('pageshow', function (e) {
    if (e.persisted) location.reload();
  });
  document.addEventListener('visibilitychange', () => {
    if (!document.hidden) {
      // Si deseas, aquí podrías refrescar números vía fetch al backend
      // location.reload(); // si prefieres recargar todo el dashboard
    }
  });
</script>

<?php include '../templates/footer.php'; ?>
