<?php
session_start();
if (!isset($_SESSION['usuario'])) {
    header("Location: ../../login.php");
    exit();
}
require_once __DIR__ . '/../templates/header.php';
require_once __DIR__ . '/../templates/navbar.php';   // ← nuevo
require_once __DIR__ . '/../templates/sidebar.php';
?>

<!-- Estilos y scripts para DataTables con botones -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

<style>
    .dt-buttons {
        text-align: right;
        margin-bottom: 15px;
    }

    .btn-exportar, .btn-imprimir {
        background-color: #2ecc71;
        color: white !important;
        border: none;
        padding: 6px 12px;
        margin-right: 10px;
        border-radius: 5px;
        font-size: 14px;
    }
</style>

<div class="contenido-principal">
    <h2>ðŸ“œ Historial de Movimientos</h2>

    <div class="table-container">
        <table id="tablaMovimientos">
            <thead>
                <tr>
                    <th>CÃ³digo</th>
                    <th>Nombre</th>
                    <th>Trabajador</th>
                    <th>Tipo</th>
                    <th>Cantidad</th>
                    <th>Motivo</th>
                    <th>Fecha Salida</th>
                    <th>Fecha Retorno</th>
                    <th>Estado</th>
                    <th>AcciÃ³n</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $sql = "SELECT m.id, p.codigo, p.nombre, m.trabajador, m.tipo_movimiento, m.cantidad, m.motivo, m.fecha_salida, m.fecha_retorno, m.estado 
                        FROM movimientos m
                        INNER JOIN productos p ON m.producto_id = p.id
                        ORDER BY m.fecha_salida DESC";
                $resultado = $conexion->query($sql);

                while ($fila = $resultado->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>" . htmlspecialchars($fila['codigo']) . "</td>";
                    echo "<td>" . htmlspecialchars($fila['nombre']) . "</td>";
                    echo "<td>" . htmlspecialchars($fila['trabajador']) . "</td>";

                    $tipo = strtolower($fila['tipo_movimiento']);
                    if ($tipo === 'salida_sin_retorno') {
                        echo "<td><span style='color: red; font-weight: bold;'>Salida sin retorno</span></td>";
                    } elseif ($tipo === 'salida') {
                        echo "<td><span style='color: orange; font-weight: bold;'>Salida con retorno</span></td>";
                    } else {
                        echo "<td>" . ucfirst($tipo) . "</td>";
                    }

                    echo "<td>" . $fila['cantidad'] . "</td>";
                    echo "<td>" . htmlspecialchars($fila['motivo']) . "</td>";
                    echo "<td>" . $fila['fecha_salida'] . "</td>";
                    echo "<td>" . ($fila['fecha_retorno'] ?? '-') . "</td>";

                    if ($fila['estado'] === 'devuelto' || $tipo === 'salida_sin_retorno') {
                        echo "<td><span class='estado-devuelto'>" . 
                            ($tipo === 'salida_sin_retorno' ? 'No retorna' : 'Devuelto') . 
                            "</span></td>";
                        echo "<td><button class='btn-devuelto' disabled>âœ“ " . 
                            ($tipo === 'salida_sin_retorno' ? 'Sin retorno' : 'Devuelto') . 
                            "</button></td>";
                    } else {
                        echo "<td><span class='estado-pendiente'>Pendiente</span></td>";
                        echo "<td>
                                <form method='POST' action='../../controllers/marcar_devolucion.php' style='margin:0;'>
                                    <input type='hidden' name='id_movimiento' value='{$fila['id']}'>
                                    <button type='submit' class='btn-devolver'>Marcar Devuelto</button>
                                </form>
                              </td>";
                    }

                    echo "</tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Inicializar DataTables -->
<script>
    $(document).ready(function () {
        $('#tablaMovimientos').DataTable({
            dom: 'Bfrtip',
            buttons: [
                {
                    extend: 'excelHtml5',
                    text: 'ðŸ“¥ Exportar a Excel',
                    className: 'btn-exportar'
                },
                {
                    extend: 'print',
                    text: 'ðŸ–¨ Imprimir',
                    className: 'btn-imprimir'
                }
            ],
            language: {
                url: "//cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json"
            }
        });
    });
</script>

<?php include '../templates/footer.php'; ?>
