<?php
include '../../../config/db.php';

if (isset($_POST['id'])) {
    $movimiento_id = $_POST['id'];

    // 1. Obtener los datos del movimiento (cantidad y producto_id)
    $sql = "SELECT producto_id, cantidad FROM movimientos WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $movimiento_id);
    $stmt->execute();
    $stmt->bind_result($producto_id, $cantidad);
    $stmt->fetch();
    $stmt->close();

    if ($producto_id && $cantidad) {
        // 2. Actualizar stock del producto
        $updateStock = "UPDATE productos SET stock = stock + ? WHERE id = ?";
        $stmt2 = $conn->prepare($updateStock);
        $stmt2->bind_param("ii", $cantidad, $producto_id);
        $stmt2->execute();
        $stmt2->close();

        // 3. Marcar como devuelto
        $updateMovimiento = "UPDATE movimientos SET estado = 'devuelto' WHERE id = ?";
        $stmt3 = $conn->prepare($updateMovimiento);
        $stmt3->bind_param("i", $movimiento_id);
        $stmt3->execute();
        $stmt3->close();
    }
}

header("Location: listar_movimientos.php");
exit();
