<?php
// ⬇️ Anti-caché: debe ir ANTES de cualquier salida
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");
header("Expires: 0");

session_start();
if (!isset($_SESSION['usuario_id'])) {
  header("Location: ../../login.php");
  exit();
}

require_once __DIR__ . '/../templates/header.php';
require_once __DIR__ . '/../templates/navbar.php';
require_once __DIR__ . '/../templates/sidebar.php';
?>

<!-- Contenido -->
<div class="content-wrapper">
  <section class="content-header">
    <h3 class="mb-4">Registrar Movimiento de Salida</h3>
  </section>

  <section class="content">
    <div class="container-fluid">
      <form id="formMovimiento">
        <div class="card card-outline card-primary">
          <div class="card-body row">
            <!-- Tipo de movimiento -->
            <div class="form-group col-md-6">
              <label for="tipo_movimiento">Tipo de Movimiento:</label>
              <select class="form-control" name="tipo_movimiento" id="tipo_movimiento" required>
                <option value="">Seleccione...</option>
                <option value="con_retorno">Movimiento con retorno</option>
                <option value="sin_retorno">Salida sin retorno</option>
              </select>
            </div>

            <!-- Código del producto (QR general) -->
            <div class="form-group col-md-6">
              <label for="codigo_producto">Código del Producto:</label>
              <div class="input-group">
                <input type="text" name="codigo_producto" id="codigo_producto" class="form-control" placeholder="Escribe o escanea el código" required autocomplete="off">
                <div class="input-group-append">
                  <button class="btn btn-dark" type="button" id="btnEscanearQR">
                    <i class="fas fa-qrcode"></i> Escanear
                  </button>
                </div>
              </div>
            </div>

            <!-- Trabajador (solo con retorno) -->
            <div class="form-group col-md-6" id="grupo_trabajador" style="display:none;">
              <label for="trabajador_id">Trabajador:</label>
              <select name="trabajador_id" id="trabajador_id" class="form-control"></select>
              <button type="button" class="btn btn-sm btn-link text-primary" id="btnNuevoTrabajador">+ Nuevo</button>
            </div>

            <!-- Cliente/Responsable (solo sin retorno) -->
            <div class="form-group col-md-6" id="grupo_cliente" style="display:none;">
              <label for="cliente_responsable">Cliente / Responsable:</label>
              <input type="text" name="cliente_responsable" id="cliente_responsable" class="form-control" placeholder="Nombre del cliente o responsable">
            </div>

            <!-- Motivo -->
            <div class="form-group col-md-6">
              <label for="motivo">Motivo:</label>
              <input type="text" name="motivo" id="motivo" class="form-control" required>
            </div>

            <!-- Cantidad -->
            <div class="form-group col-md-6">
              <label for="cantidad">Cantidad:</label>
              <input type="number" name="cantidad" id="cantidad" class="form-control" min="1" value="1" required>
            </div>

            <!-- Fecha retorno (solo con retorno) -->
            <div class="form-group col-md-6" id="grupo_retorno" style="display:none;">
              <label for="fecha_retorno">Fecha de retorno esperada:</label>
              <input type="date" name="fecha_retorno" id="fecha_retorno" class="form-control">
            </div>

            <div class="form-group col-12 text-right">
              <button type="submit" class="btn btn-success">Registrar Movimiento</button>
            </div>
          </div>
        </div>
      </form>

      <!-- Historial -->
      <div class="card card-outline card-info mt-4">
        <div class="card-header">
          <h3 class="card-title">Historial de Movimientos</h3>
        </div>
        <div class="card-body table-responsive">
          <table id="tablaMovimientos" class="table table-bordered table-striped">
            <thead>
              <tr>
                <th>ID</th>
                <th>Producto</th>
                <th>Tipo</th>
                <th>Responsable</th>
                <th>Cantidad</th>
                <th>Motivo</th>
                <th>Fecha Salida</th>
                <th>Fecha Retorno</th>
                <th>Estado</th>
                <th>Acciones</th>
              </tr>
            </thead>
            <tbody><!-- JS --></tbody>
          </table>
        </div>
      </div>
    </div>
  </section>
</div>

<!-- Modal Escáner QR -->
<div class="modal fade" id="modalEscanerQR" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
    <div class="modal-content bg-dark text-white text-center">
      <div class="modal-header">
        <h5 class="modal-title">Escanear Código QR</h5>
        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Cerrar">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body p-2">
        <video id="video" style="width:100%; border-radius:8px; object-fit:cover;"></video>
      </div>
    </div>
  </div>
</div>

<!-- Modal Nuevo Trabajador -->
<div class="modal fade" id="modalTrabajador" tabindex="-1" role="dialog" aria-labelledby="modalTrabajadorLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <form id="formTrabajador">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Registrar Nuevo Trabajador</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <input type="text" name="nombre" class="form-control mb-2" placeholder="Nombre completo" required>
          <input type="text" name="dni" class="form-control mb-2" placeholder="DNI" required>
          <input type="text" name="telefono" class="form-control mb-2" placeholder="Teléfono" required>
          <input type="email" name="correo" class="form-control mb-2" placeholder="Correo" required>
          <input type="text" name="cargo" class="form-control mb-2" placeholder="Cargo (opcional)">
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-success">Guardar</button>
        </div>
      </div>
    </form>
  </div>
</div>

<?php require_once __DIR__ . '/../templates/footer.php'; ?>

<!-- Librería QR -->
<script src="<?= BASE_URL ?>assets/js/qr/qr-scanner.umd.min.js?v=1"></script>
<script>
  if (window.QrScanner) {
    QrScanner.WORKER_PATH = "<?= BASE_URL ?>assets/js/qr/qr-scanner-worker.min.js";
  }
</script>

<!-- JS del módulo -->
<script src="<?= BASE_URL ?>assets/js/movimientos.js?v=1.1"></script>

<!-- ⬇️ Fix bfcache + auto-refresh al volver el foco -->
<script>
  // Si vuelve desde el historial del navegador (bfcache), recarga real
  window.addEventListener('pageshow', function (e) {
    if (e.persisted) location.reload();
  });

  // Al volver a enfocar el tab, refrescamos la tabla
  document.addEventListener('visibilitychange', () => {
    if (!document.hidden && typeof cargarMovimientos === 'function') {
      try { cargarMovimientos(); } catch(e) {}
    }
  });
</script>
