<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header('Content-Type: text/html; charset=utf-8');

// Correccin final de rutas
require_once __DIR__ . '/../templates/header.php';
require_once __DIR__ . '/../templates/navbar.php';   //  nuevo
require_once __DIR__ . '/../templates/sidebar.php';
?>

<!-- Contenido principal -->
<div class="content-wrapper">
  <section class="content">
    <div class="container-fluid py-4">

      <!-- Botn para abrir el modal -->
      <button class="btn btn-dark mb-3" data-toggle="modal" data-target="#modalDefectuoso">
        <i class="fas fa-plus"></i> Nuevo
      </button>

      <!-- Modal para registrar producto defectuoso -->
      <div class="modal fade" id="modalDefectuoso" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
            <div class="modal-header bg-dark text-white">
              <h5 class="modal-title">Registrar Producto Defectuoso</h5>
              <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
            </div>
            <form id="formDefectuoso">
              <div class="modal-body row">
                <div class="col-md-6">
                  <label>Producto</label>
                  <select name="producto_id" id="producto_id" class="form-control" required></select>
                </div>
                <div class="col-md-6">
                  <label>Cantidad</label>
                  <input type="number" name="cantidad" class="form-control" min="1" required>
                </div>
                <div class="col-md-6">
                  <label>Cdigo QR</label>
                  <input type="text" name="codigo_qr" class="form-control">
                </div>
                <div class="col-md-6">
                  <label>Descripcin</label>
                  <textarea name="descripcion" class="form-control"></textarea>
                </div>
                <div class="col-md-12">
                  <label>Observacin</label>
                  <textarea name="observacion" class="form-control"></textarea>
                </div>
              </div>
              <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Guardar</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
              </div>
            </form>
          </div>
        </div>
      </div>

      <!-- Tabla de productos defectuosos registrados -->
      <div class="card mb-4">
        <div class="card-header bg-dark text-white">
          Registro de Productos Defectuosos
        </div>
        <div class="card-body">
          <table class="table table-bordered table-hover" id="tablaRegistroDefectuosos">
            <thead class="thead-dark">
              <tr>
                <th>ID</th>
                <th>Producto</th>
                <th>Cdigo QR</th>
                <th>Cantidad</th>
                <th>Fecha Registro</th>
                <th>Descripcin</th>
                <th>Observacin</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>
      </div>

      <!-- Tabla de productos devueltos defectuosos -->
      <div class="card">
        <div class="card-header bg-dark text-white">
          Productos Devueltos Defectuosos
        </div>
        <div class="card-body">
          <table class="table table-bordered table-hover" id="tablaDevueltosDefectuosos">
            <thead class="thead-dark">
              <tr>
                <th>ID Movimiento</th>
                <th>Producto</th>
                <th>Cdigo QR</th>
                <th>Motivo</th>
                <th>Responsable</th>
                <th>Fecha Retorno</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>
      </div>

    </div>
  </section>
</div>

<?php include_once __DIR__ . '/../templates/footer.php'; ?>

<!-- Script especfico del mdulo -->
<script src="<?= BASE_URL ?>assets/js/productos_defectuosos.js"></script>
