<?php
session_start();
if (!isset($_SESSION['usuario'])) {
    header("Location: ../../login.php");
    exit();
}
include '../templates/header.php';
?>

<div style="max-width: 600px; margin: auto; padding: 30px;">
    <h2>Registrar Salida sin Retorno</h2>

    <?php
    if (isset($_GET['mensaje']) && $_GET['mensaje'] == 'registrado') {
        echo "<div class='success-message'>✅ Salida registrada correctamente.</div>";
    } elseif (isset($_GET['mensaje']) && $_GET['mensaje'] == 'error') {
        echo "<div class='error-message'>❌ Error al registrar la salida.</div>";
    }
    ?>

    <form method="POST" action="../../controllers/guardar_salida_sin_retorno.php">
        <input type="hidden" name="tipo" value="sin_retorno">

        <label for="codigo">Código del Producto:</label>
        <div style="display: flex; gap: 10px;">
            <input type="text" name="codigo" id="codigo" required style="flex: 1;">
            <button type="button" class="btn-qr" onclick="iniciarQR()">📷 QR</button>
        </div>

        <label for="trabajador">Trabajador responsable:</label>
        <input type="text" name="trabajador" required>

        <label for="motivo">Motivo de salida:</label>
        <input type="text" name="motivo" required>

        <label for="cantidad">Cantidad:</label>
        <input type="number" name="cantidad" required min="1">

        <button type="submit" style="margin-top: 20px;" class="btn-guardar">Registrar Salida</button>
    </form>

    <video id="video" style="width:100%; margin-top:15px;" hidden></video>
</div>

<script src="https://cdn.jsdelivr.net/npm/qr-scanner@1.4.2/qr-scanner.min.js"></script>
<script>
    let video = document.getElementById('video');
    let scanner;

    function iniciarQR() {
        video.removeAttribute("hidden");
        scanner = new QrScanner(video, result => {
            document.getElementById('codigo').value = result;
            scanner.stop();
            video.setAttribute("hidden", true);
        });
        scanner.start();
    }
</script>

<?php include '../templates/footer.php'; ?>
