<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../templates/header.php';
require_once __DIR__ . '/../templates/navbar.php';   // ← nuevo
require_once __DIR__ . '/../templates/sidebar.php';
?>

<div class="content-wrapper">
  <section class="content-header">
    <div class="container-fluid d-flex justify-content-between align-items-center">
      <h1 class="mb-0">Tipos de Producto</h1>
      <button class="btn btn-primary" id="btnNuevoTipo" onclick="mostrarModal()">Nuevo Tipo</button>
    </div>
  </section>

  <section class="content">
    <div class="container-fluid">
      <div class="card shadow">
        <div class="card-header bg-primary text-white">
          <h3 class="card-title">Lista de Tipos</h3>
        </div>
        <div class="card-body">
          <table class="table table-bordered table-hover" id="tablaTipos">
            <thead class="thead-dark">
              <tr>
                <th>ID</th>
                <th>Nombre</th>
                <th>Categoría</th> <!-- NUEVO -->
                <th>Acción</th>
              </tr>
            </thead>
            <tbody>
              <!-- Cargado dinámicamente con tipos.js -->
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </section>
</div>

<!-- Modal -->
<div class="modal fade" id="modalTipo" tabindex="-1" role="dialog" aria-labelledby="modalTipoLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <form id="formTipo">
      <div class="modal-content">
        <div class="modal-header bg-dark text-white">
          <h5 class="modal-title" id="modalTipoLabel">Registrar / Editar Tipo</h5>
          <button type="button" class="close text-white" data-dismiss="modal" aria-label="Cerrar">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="id" id="tipo_id">

          <div class="form-group">
            <label for="tipo_categoria_id">Categoría</label>
            <select id="tipo_categoria_id" name="categoria_id" class="form-control" required>
              <option value="">Seleccione...</option>
            </select>
          </div>

          <div class="form-group">
            <label for="nombre">Nombre del Tipo</label>
            <input type="text" class="form-control" name="nombre" id="nombre" required placeholder="Ej. Brocas, Cables...">
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-success">Guardar</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
        </div>
      </div>
    </form>
  </div>
</div>

<?php include "../templates/footer.php"; ?>

<script src="<?= BASE_URL ?>assets/js/tipos.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
